<?php 
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/Popup.php";
    
    if(isset($_GET["id"])) {
        $popup = new Popup($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $popup->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione popup</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Popup creata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Popup modificata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="card mb-4 box-shadow-lite">

                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($popup) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($popup) ? $popup->getId() : "0")); ?>">
                                
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-12 col-lg-6 d-md-flex">
                                            <h6 class="mt-2 mr-2 text-nowrap">Popup:</h6>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome Slider" value="<?php echo((isset($popup) ? $popup->getNome() : "")) ?>" placeholder="Nome occorrenza">
                                        </div>
                                        <div class="col text-right">
                                            <a class="btn btn-outline-primary mt-2 mt-lg-0" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                            <button class="btn btn-primary mt-2 mt-lg-0" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                            <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerComponente.php?id=1&amp;operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-7">
                                                <div class="row">

                                                    <div class="col-md-4 form-group">
                                                        <label for="inputPassword3" >Dove deve apparire?</label>
                                                        <select class="form-control" name="categoria">
                                                            <option value="-1">Seleziona</option>
                                                            <option value="0" <?php if(isset($popup) && $popup->getCategoria()==0) echo "selected"; ?>>Home</option>
                                                            <?php
                                                                $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo'";
                                                                $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                                while($categoria = $risNomi->fetch_assoc()) {
                                                                    if(isset($popup) && $popup->getCategoria()==$categoria["id"]) {
                                                                        $selezionato  = "selected";
                                                                    }
                                                                    else {
                                                                        $selezionato  = "";
                                                                    }
                                                                    echo"<option value=\"{$categoria["id"]}\" $selezionato >{$categoria["nome"]}</option>";
                                                                }
                                                            ?>
                                                        </select>
                                                        <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                                    </div>

                                                    <div class="col-md-4 form-group">
                                                        <label for="inputPassword3" >Dopo quanti secondi deve apparire?</label>
                                                        <input type="number" class="form-control" name="secondi" value="<?php echo((isset($popup)) ? $popup->getSecondi() : "0") ?>">
                                                        <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                                    </div>

                                                    <div class="col-md-4 form-group">
                                                        <label for="inputPassword3" >Link immagine</label>
                                                        <input type="text" class="form-control" name="link" value="<?php echo((isset($popup)) ? $popup->getLink() : "") ?>">
                                                        <small class="text-muted">Il link sarà attivo solo se il campo testo è vuoto</small>
                                                    </div>
                                                    
                                                    <div class="form-group col-12">
                                                        <textarea class="tiny" name="testo"><?php echo(isset($popup) ? $popup->getTesto() : "") ?></textarea>
                                                    </div>

                                                </div>
                                                </form>
                                            </div>

                                        <div class="col-lg-5  align-self-start sticky-top">
                                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                                <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                                    <a class="card-title">
                                                        Immagine
                                                    </a>
                                                </div>
                                                <div id="ImmagineInEvidenza" class="collapse show">
                                                    <div class="card-body">
                                                        <div class="img-container">
                                                            <div class="azioni">
                                                                <div class="btn-group" role="group" aria-label="">
                                                                    <button onclick="eliminaImmagineOccorrenza()()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                                </div>
                                                            </div>
                                                            <img id="immagineElemento" class="img-fluid w-100 mb-3" src="../../../<?php echo((isset($popup) && $popup->getImmagine()!="") ? $popup->getImmagine() : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                                        </div>

                                                        <button type="button" class="btn btn-outline-primary btn-block mb-3" onclick="apriPopupSelezioneImmagini()"><i class="far fa-image"></i> Scegli da immagini caricate</button>

                                                        <form action="controller/controllerComponente.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                                            <div class="dz-message">
                                                                <i class="fas fa-file-upload fa-2x mb-2"></i>
                                                                <h5>Trascina o carica qui l'immagine</h5>
                                                            </div>
                                                            <div class="fallback">
                                                                <input name="file" type="file" />
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../../include/modal/modalSelezionaFoto.php";
            
            include "../include/jsBaseComponenti.php";
        ?>

        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineElemento").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagine",
                    id:<?php echo $popup->getId() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            function eliminaImmagineOccorrenza() {
                $.ajax({
                    type:"GET",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaImmagineOccorrenza",
                        id:<?php echo $popup->getId() ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineElemento").src="../../../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function apriPopupSelezioneImmagini() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaPopup",
                        immaginePartenza:0,
                        numeroImmagini:18
                    },
                    success:function(codice) {
                        document.getElementById("divSelezioneFoto").innerHTML = codice;
                        $('#modal-seleziona-foto').modal('show');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaImmagineInEvidenzaDaPopup(percorso) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"modificaImmagineOccorrenzaConPercorso",
                        id:<?php echo $popup->getId() ?>,
                        percorso:percorso
                    },
                    success:function(risposta) {
                        if(risposta=="ok") {
                            document.getElementById("immagineElemento").src = "../../../"+percorso;
                        }
                        else {
                            alert(risposta);
                        }
                    }
                });
                $('#modal-seleziona-foto').modal('hide');
            }
            
            function aggiungiImmaginiModalSelezioneImmagini(immaginePartenza,numeroImmagini) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        id:<?php echo $popup->getId() ?>,
                        immaginePartenza:immaginePartenza,
                        numeroImmagini:numeroImmagini
                    },
                    success:function(codice) {
                        var vecchioCodice = document.getElementById("divSelezioneFoto").innerHTML; 
                        document.getElementById("divSelezioneFoto").innerHTML = vecchioCodice+codice;
                        
                        // aggiorno i dati del pulsante
                        var nuovaImmagineDiPartenza = immaginePartenza+numeroImmagini;
                        document.getElementById("divBottoneModalSelezionaFoto").innerHTML = '<button type="button" class="btn btn-outline-primary" onclick="aggiungiImmaginiModalSelezioneImmagini('+nuovaImmagineDiPartenza+','+numeroImmagini+')">Mostra altre immagini</button>';
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
